/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.TileEntitySpawnerRenderer;
import com.flansmod.client.debug.EntityDebugAABB;
import com.flansmod.client.debug.EntityDebugDot;
import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.client.debug.RenderDebugAABB;
import com.flansmod.client.debug.RenderDebugDot;
import com.flansmod.client.debug.RenderDebugVector;
import com.flansmod.client.gui.GuiArmourBox;
import com.flansmod.client.gui.GuiDriveableCrafting;
import com.flansmod.client.gui.GuiDriveableFuel;
import com.flansmod.client.gui.GuiDriveableInventory;
import com.flansmod.client.gui.GuiDriveableMenu;
import com.flansmod.client.gui.GuiDriveableRepair;
import com.flansmod.client.gui.GuiGunBox;
import com.flansmod.client.gui.GuiGunModTable;
import com.flansmod.client.gui.GuiMechaInventory;
import com.flansmod.client.gui.GuiPaintjobTable;
import com.flansmod.client.handlers.ClientEventHandler;
import com.flansmod.client.handlers.FlansModResourceHandler;
import com.flansmod.client.handlers.KeyInputHandler;
import com.flansmod.client.model.RenderAAGun;
import com.flansmod.client.model.RenderBullet;
import com.flansmod.client.model.RenderFlag;
import com.flansmod.client.model.RenderFlagpole;
import com.flansmod.client.model.RenderGrenade;
import com.flansmod.client.model.RenderGun;
import com.flansmod.client.model.RenderGunItem;
import com.flansmod.client.model.RenderItemHolder;
import com.flansmod.client.model.RenderMG;
import com.flansmod.client.model.RenderMecha;
import com.flansmod.client.model.RenderNull;
import com.flansmod.client.model.RenderParachute;
import com.flansmod.client.model.RenderPlane;
import com.flansmod.client.model.RenderVehicle;
import com.flansmod.common.CommonProxy;
import com.flansmod.common.EntityItemCustomRender;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.TileEntityItemHolder;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.guns.EntityAAGun;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.EntityMG;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.guns.boxes.BlockGunBox;
import com.flansmod.common.guns.boxes.BoxType;
import com.flansmod.common.guns.boxes.GunBoxType;
import com.flansmod.common.network.PacketBuyArmour;
import com.flansmod.common.network.PacketBuyWeapon;
import com.flansmod.common.network.PacketCraftDriveable;
import com.flansmod.common.network.PacketRepairDriveable;
import com.flansmod.common.paintjob.TileEntityPaintjobTable;
import com.flansmod.common.teams.ArmourBoxType;
import com.flansmod.common.teams.BlockArmourBox;
import com.flansmod.common.teams.EntityFlag;
import com.flansmod.common.teams.EntityFlagpole;
import com.flansmod.common.teams.TileEntitySpawner;
import com.flansmod.common.tools.EntityParachute;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.PaintableType;
import com.flansmod.common.vector.Vector3f;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static String modelDir = "com.flansmod.client.model.";
    public static RenderGun gunRenderer;
    public List<SoundEvent> eventsToRegister = new ArrayList<SoundEvent>();
    private FlansModClient flansModClient;

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void init() {
        this.flansModClient = new FlansModClient();
        this.flansModClient.load();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityItemHolder.class, (TileEntitySpecialRenderer)new RenderItemHolder());
        ClientEventHandler eventHandler = new ClientEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
    }

    @SubscribeEvent
    public void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        FlansMod.log.info("Registering sounds.");
        for (SoundEvent sound : this.eventsToRegister) {
            event.getRegistry().register((IForgeRegistryEntry)sound);
        }
        event.getRegistry().register((IForgeRegistryEntry)FlansModResourceHandler.getSoundEvent("bulletFlyby"));
        event.getRegistry().register((IForgeRegistryEntry)FlansModResourceHandler.getSoundEvent("UnlockNotch"));
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        FlansMod.log.info("Registering models.");
        for (InfoType type : InfoType.infoTypes.values()) {
            if (type == null || type.item == null) continue;
            if (type instanceof PaintableType) {
                for (Paintjob paintjob : ((PaintableType)type).paintjobs) {
                    ModelLoader.registerItemVariants((Item)type.item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("flansmod:" + type.shortName + (paintjob.iconName.equals("") ? "" : "_" + paintjob.iconName))});
                    ModelLoader.setCustomModelResourceLocation((Item)type.item, (int)paintjob.ID, (ModelResourceLocation)new ModelResourceLocation("flansmod:" + type.shortName + (paintjob.iconName.equals("") ? "" : "_" + paintjob.iconName), "inventory"));
                }
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)type.item, (int)0, (ModelResourceLocation)new ModelResourceLocation("flansmod:" + type.shortName, "inventory"));
        }
        FlansMod.Assert(FlansMod.workbenchItem == Item.func_150898_a((Block)FlansMod.workbench), "ItemBlock Mismatch");
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.workbenchItem, (int)0, (ModelResourceLocation)new ModelResourceLocation("flansmod:flansworkbench_guns", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.workbenchItem, (int)0, (ModelResourceLocation)new ModelResourceLocation("flansmod:flansworkbench_guns", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.workbenchItem, (int)1, (ModelResourceLocation)new ModelResourceLocation("flansmod:flansworkbench_vehicles", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.workbenchItem, (int)2, (ModelResourceLocation)new ModelResourceLocation("flansmod:flansworkbench_parts", "inventory"));
        ModelLoader.registerItemVariants((Item)FlansMod.workbenchItem, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("flansmod:flansWorkbench_guns"), new ResourceLocation("flansmod:flansWorkbench_parts"), new ResourceLocation("flansmod:flansWorkbench_vehicles")});
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.opStick, (int)0, (ModelResourceLocation)new ModelResourceLocation("flansmod:opstick_Ownership", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.opStick, (int)1, (ModelResourceLocation)new ModelResourceLocation("flansmod:opstick_Connecting", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.opStick, (int)2, (ModelResourceLocation)new ModelResourceLocation("flansmod:opstick_Mapping", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.opStick, (int)3, (ModelResourceLocation)new ModelResourceLocation("flansmod:opstick_Destruction", "inventory"));
        ModelLoader.registerItemVariants((Item)FlansMod.opStick, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("flansmod:opstick_Ownership"), new ResourceLocation("flansmod:opstick_Connecting"), new ResourceLocation("flansmod:opstick_Mapping"), new ResourceLocation("flansmod:opstick_Destruction")});
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.spawnerItem, (int)0, (ModelResourceLocation)new ModelResourceLocation("flansmod:teamsSpawner_items", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.spawnerItem, (int)1, (ModelResourceLocation)new ModelResourceLocation("flansmod:teamsSpawner_players", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.spawnerItem, (int)2, (ModelResourceLocation)new ModelResourceLocation("flansmod:teamsSpawner_vehicles", "inventory"));
        ModelLoader.registerItemVariants((Item)FlansMod.spawnerItem, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("flansmod:teamsSpawner_items"), new ResourceLocation("flansmod:teamsSpawner_players"), new ResourceLocation("flansmod:teamsSpawner_vehicles")});
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.flag, (int)0, (ModelResourceLocation)new ModelResourceLocation("flansmod:flagpole", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.rainbowPaintcan, (int)0, (ModelResourceLocation)new ModelResourceLocation("flansmod:rainbowPaintcan", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)FlansMod.paintjobTable), (int)0, (ModelResourceLocation)new ModelResourceLocation("flansmod:paintjobTable", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)FlansMod.gunpowderBlock), (int)0, (ModelResourceLocation)new ModelResourceLocation("flansmod:gunpowderblock", "inventory"));
        ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)FlansMod.paintjobTable), (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("flansmod:paintjobTable")});
        ModelLoader.setCustomModelResourceLocation((Item)FlansMod.crosshairsymbol, (int)0, (ModelResourceLocation)new ModelResourceLocation("flansmod:crosshairsymbol", "inventory"));
    }

    @Override
    public void forceReload() {
        FMLClientHandler.instance().refreshResources(new IResourceType[]{VanillaResourceType.MODELS, VanillaResourceType.TEXTURES, VanillaResourceType.SOUNDS, VanillaResourceType.LANGUAGES});
    }

    @Override
    public void LoadAssetsFromFlanFolder() {
        ClassLoader classloader = Minecraft.class.getClassLoader();
        Method method = null;
        try {
            method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
        }
        catch (Exception e) {
            FlansMod.log.error("Failed to get class loader. All content loading will now fail.");
            FlansMod.log.throwing((Throwable)e);
        }
        for (File file : FlansMod.flanDir.listFiles()) {
            if (!file.isDirectory() && !zipJar.matcher(file.getName()).matches()) continue;
            try {
                method.invoke((Object)classloader, file.toURI().toURL());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("modid", "flansmod");
                map.put("name", "Flan's Mod : " + file.getName());
                map.put("version", "1");
                FMLModContainer container = new FMLModContainer("com.flansmod.common.FlansMod", new ModCandidate(file, file, file.isDirectory() ? ContainerType.DIR : ContainerType.JAR), map);
                container.bindMetadata(MetadataCollection.from(null, (String)""));
                FMLClientHandler.instance().addModAsResource((ModContainer)container);
            }
            catch (Exception e) {
                FlansMod.log.error("Failed to load images for content pack : " + file.getName());
                FlansMod.log.throwing((Throwable)e);
            }
            FlansMod.log.info("Loaded content pack : " + file.getName());
        }
        FlansMod.log.info("Loaded textures and models.");
    }

    @Override
    public void registerRenderers() {
        FlansMod.log.info("Registering Renderers");
        RenderingRegistry.registerEntityRenderingHandler(EntityBullet.class, (IRenderFactory)new RenderBullet.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, (IRenderFactory)new RenderGrenade.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityPlane.class, (IRenderFactory)new RenderPlane.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityVehicle.class, (IRenderFactory)new RenderVehicle.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityAAGun.class, (IRenderFactory)new RenderAAGun.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityFlagpole.class, (IRenderFactory)new RenderFlagpole.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityFlag.class, (IRenderFactory)new RenderFlag.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntitySeat.class, new RenderNull.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityWheel.class, new RenderNull.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityMG.class, (IRenderFactory)new RenderMG.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityParachute.class, (IRenderFactory)new RenderParachute.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityDebugDot.class, (IRenderFactory)new RenderDebugDot.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityDebugVector.class, (IRenderFactory)new RenderDebugVector.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityDebugAABB.class, (IRenderFactory)new RenderDebugAABB.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityMecha.class, (IRenderFactory)new RenderMecha.Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityItemCustomRender.class, (IRenderFactory)new RenderGunItem.Factory());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySpawner.class, (TileEntitySpecialRenderer)new TileEntitySpawnerRenderer());
    }

    @Override
    public void doTutorialStuff(EntityPlayer player, EntityDriveable entityType) {
        if (!FlansModClient.doneTutorial) {
            FlansModClient.doneTutorial = true;
            player.func_145747_a((ITextComponent)new TextComponentString("Press " + Keyboard.getKeyName((int)KeyInputHandler.vehicleMenuKey.func_151463_i()) + " to open the menu"));
            player.func_145747_a((ITextComponent)new TextComponentString("Press " + Keyboard.getKeyName((int)Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i()) + " to get out"));
            player.func_145747_a((ITextComponent)new TextComponentString("Press " + Keyboard.getKeyName((int)KeyInputHandler.controlSwitchKey.func_151463_i()) + " to switch controls"));
            player.func_145747_a((ITextComponent)new TextComponentString("Press " + Keyboard.getKeyName((int)KeyInputHandler.modeKey.func_151463_i()) + " to switch VTOL mode"));
            if (entityType instanceof EntityPlane) {
                if (PlaneType.getPlane((String)((EntityPlane)entityType).driveableType).hasGear) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Press " + Keyboard.getKeyName((int)KeyInputHandler.gearKey.func_151463_i()) + " to switch the gear"));
                }
                if (PlaneType.getPlane((String)((EntityPlane)entityType).driveableType).hasDoor) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Press " + Keyboard.getKeyName((int)KeyInputHandler.doorKey.func_151463_i()) + " to switch the doors"));
                }
                if (PlaneType.getPlane((String)((EntityPlane)entityType).driveableType).hasWing) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Press " + Keyboard.getKeyName((int)KeyInputHandler.modeKey.func_151463_i()) + " to switch the wings"));
                }
            }
        }
    }

    @Override
    public void changeControlMode(EntityPlayer player) {
        if (FlansModClient.flipControlMode()) {
            player.func_145747_a((ITextComponent)new TextComponentString("Mouse Control mode is now set to " + FlansModClient.controlModeMouse));
        }
    }

    @Override
    public boolean mouseControlEnabled() {
        return FlansModClient.controlModeMouse;
    }

    @Override
    public Object getClientGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if ((ID >= 6 && ID <= 10 || ID == 12) && player.func_184187_bx() == null) {
            return null;
        }
        switch (ID) {
            case 0: {
                return new GuiDriveableCrafting(player.field_71071_by);
            }
            case 1: {
                return new GuiDriveableRepair(player);
            }
            case 2: {
                return new GuiGunModTable(player.field_71071_by, world);
            }
            case 5: {
                return new GuiGunBox(player.field_71071_by, ((BlockGunBox)world.func_180495_p((BlockPos)new BlockPos((int)x, (int)y, (int)z)).func_177230_c()).type);
            }
            case 6: {
                return new GuiDriveableInventory(player.field_71071_by, world, ((EntitySeat)player.func_184187_bx()).driveable, 0);
            }
            case 7: {
                return new GuiDriveableInventory(player.field_71071_by, world, ((EntitySeat)player.func_184187_bx()).driveable, 1);
            }
            case 8: {
                return new GuiDriveableFuel(player.field_71071_by, world, ((EntitySeat)player.func_184187_bx()).driveable);
            }
            case 9: {
                return new GuiDriveableInventory(player.field_71071_by, world, ((EntitySeat)player.func_184187_bx()).driveable, 2);
            }
            case 10: {
                return new GuiMechaInventory(player.field_71071_by, world, (EntityMecha)((EntitySeat)player.func_184187_bx()).driveable);
            }
            case 11: {
                return new GuiArmourBox(player.field_71071_by, ((BlockArmourBox)world.func_180495_p((BlockPos)new BlockPos((int)x, (int)y, (int)z)).func_177230_c()).type);
            }
            case 12: {
                return new GuiDriveableInventory(player.field_71071_by, world, ((EntitySeat)player.func_184187_bx()).driveable, 3);
            }
            case 13: {
                return new GuiPaintjobTable(player.field_71071_by, world, (TileEntityPaintjobTable)world.func_175625_s(new BlockPos(x, y, z)));
            }
        }
        return null;
    }

    @Override
    public void openDriveableMenu(EntityPlayer player, World world, EntityDriveable driveable) {
        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiDriveableMenu(player.field_71071_by, world, driveable));
    }

    private String getModelName(String in) {
        String[] split = in.split("\\.");
        if (split.length == 1) {
            return modelDir + "Model" + in;
        }
        if (split.length > 1) {
            if (split.length == 2 && FlansMod.modelDirectories.containsKey(split[0])) {
                return FlansMod.modelDirectories.get(split[0]) + ".Model" + split[1];
            }
            String out = "Model" + split[split.length - 1];
            for (int i = split.length - 2; i >= 0; --i) {
                out = split[i] + "." + out;
            }
            return modelDir + out;
        }
        return modelDir + in;
    }

    @Override
    public <T> T loadModel(String s, String shortName, Class<T> typeClass) {
        if (s == null || shortName == null) {
            return null;
        }
        try {
            return typeClass.cast(Class.forName(this.getModelName(s)).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            FlansMod.log.error("Failed to load model : " + shortName + " (" + s + ")");
            FlansMod.log.throwing((Throwable)e);
            return null;
        }
    }

    @Override
    public void loadSound(String contentPack, String type, String sound) {
        SoundEvent event = FlansModResourceHandler.getSoundEvent(sound);
        if (event == null) {
            FlansMod.log.warn("Null sound event");
            return;
        }
        if (!this.eventsToRegister.contains(event)) {
            this.eventsToRegister.add(event);
        }
    }

    @Override
    public boolean isThePlayer(EntityPlayer player) {
        return player == FMLClientHandler.instance().getClient().field_71439_g;
    }

    @Override
    public void buyGun(GunBoxType type, InfoType gun) {
        FlansMod.getPacketHandler().sendToServer(new PacketBuyWeapon(type, gun));
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        data.shootTimeRight = 10.0f;
        data.shootTimeLeft = 10.0f;
    }

    @Override
    public void buyArmour(String shortName, int piece, ArmourBoxType box) {
        FlansMod.getPacketHandler().sendToServer(new PacketBuyArmour(box.shortName, shortName, piece));
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        data.shootTimeRight = 10.0f;
        data.shootTimeLeft = 10.0f;
    }

    @Override
    public void craftDriveable(EntityPlayer player, DriveableType type) {
        super.craftDriveable(player, type);
        if (player.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToServer(new PacketCraftDriveable(type.shortName));
        }
    }

    @Override
    public void repairDriveable(EntityPlayer driver, EntityDriveable driving, DriveablePart part) {
        super.repairDriveable(driver, driving, part);
        if (driver.field_70170_p.field_72995_K) {
            FlansMod.getPacketHandler().sendToServer(new PacketRepairDriveable(part.type));
        }
    }

    @Override
    public boolean isScreenOpen() {
        return Minecraft.func_71410_x().field_71462_r != null;
    }

    @Override
    public boolean isKeyDown(int key) {
        switch (key) {
            case 0: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151463_i());
            }
            case 1: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151463_i());
            }
            case 2: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151463_i());
            }
            case 3: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151463_i());
            }
            case 4: {
                return this.keyDown(Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151463_i());
            }
        }
        return false;
    }

    @Override
    public boolean keyDown(int keyCode) {
        return keyCode < 0 ? Mouse.isButtonDown((int)(keyCode + 100)) : Keyboard.isKeyDown((int)keyCode);
    }

    @SubscribeEvent
    public void playerClick(PlayerInteractEvent event) {
        Vec3d eye = event.getEntityPlayer().func_174824_e(0.0f);
        Vec3d look = event.getEntityPlayer().func_70040_Z();
        double interactDistance = event.getEntityPlayer().func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        look.func_72432_b();
        look.func_186678_a(interactDistance);
        if (event instanceof PlayerInteractEvent.LeftClickBlock || event instanceof PlayerInteractEvent.RightClickBlock) {
            interactDistance = Math.min(interactDistance, Math.sqrt(event.getPos().func_177954_c(eye.field_72450_a, eye.field_72448_b, eye.field_72449_c)));
        }
        if (event instanceof PlayerInteractEvent.EntityInteractSpecific) {
            interactDistance = Math.min(interactDistance, ((PlayerInteractEvent.EntityInteractSpecific)event).getLocalPos().func_72438_d(eye));
        }
        if (event instanceof PlayerInteractEvent.EntityInteract) {
            interactDistance = Math.min(interactDistance, ((PlayerInteractEvent.EntityInteract)event).getTarget().func_70011_f(eye.field_72450_a, eye.field_72448_b, eye.field_72449_c));
        }
        for (Entity entity : event.getWorld().func_72910_y()) {
            double d2;
            if (!(entity instanceof EntityDriveable)) continue;
            EntityDriveable d = (EntityDriveable)entity;
            Vec3d L = entity.func_174791_d().func_178788_d(eye);
            double tca = L.func_72430_b(look);
            if (tca < 0.0 || (d2 = L.func_72430_b(L) - tca * tca) > d.getDriveableType().hitboxRadius) continue;
            DriveablePart partHit = d.raytraceParts(new Vector3f(eye), new Vector3f(look));
            if (event instanceof PlayerInteractEvent.LeftClickEmpty || event instanceof PlayerInteractEvent.LeftClickBlock) {
                Minecraft.func_71410_x().field_71442_b.func_78764_a(event.getEntityPlayer(), (Entity)d);
            }
            if (event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickBlock) {
                Minecraft.func_71410_x().field_71442_b.func_187097_a(event.getEntityPlayer(), (Entity)d, event.getHand());
            }
            if (!(event instanceof PlayerInteractEvent.RightClickItem)) continue;
            event.setCanceled(true);
        }
    }

    @Override
    public void addMissingJSONs(HashMap<Integer, InfoType> types) {
        for (InfoType type : types.values()) {
            try {
                File blockstatesDir;
                File blockModelsDir;
                EnumType typeToCheckFor = EnumType.getFromObject(type);
                File contentPackDir = new File(FlansMod.flanDir, type.contentPack);
                if (!contentPackDir.isDirectory()) continue;
                File itemModelsDir = new File(contentPackDir, "/assets/flansmod/models/item");
                if (!itemModelsDir.exists()) {
                    itemModelsDir.mkdirs();
                }
                if (!(blockModelsDir = new File(contentPackDir, "/assets/flansmod/models/block")).exists()) {
                    blockModelsDir.mkdirs();
                }
                if (!(blockstatesDir = new File(contentPackDir, "/assets/flansmod/blockstates")).exists()) {
                    blockstatesDir.mkdirs();
                }
                if (typeToCheckFor == EnumType.armourBox || typeToCheckFor == EnumType.box) {
                    BoxType box = (BoxType)type;
                    this.createJSONFile(new File(itemModelsDir, type.shortName.toLowerCase() + "_item.json"), "{ \"parent\": \"flansmod:block/" + type.shortName + "\", \"display\": { \"thirdperson\": { \"rotation\": [ 10, -45, 170 ], \"translation\": [ 0, 1.5, -2.75 ], \"scale\": [ 0.375, 0.375, 0.375 ] } } }");
                    this.createJSONFile(new File(blockModelsDir, type.shortName.toLowerCase() + ".json"), "{ \"parent\": \"block/cube\", \"textures\": { \"particle\": \"flansmod:blocks/" + box.sideTexturePath + "\", \"down\": \"flansmod:blocks/" + box.bottomTexturePath + "\", \"up\": \"flansmod:blocks/" + box.topTexturePath + "\", \"north\": \"flansmod:blocks/" + box.sideTexturePath + "\", \"east\": \"flansmod:blocks/" + box.sideTexturePath + "\", \"south\": \"flansmod:blocks/" + box.sideTexturePath + "\", \"west\": \"flansmod:blocks/" + box.sideTexturePath + "\" } } ");
                    this.createJSONFile(new File(blockstatesDir, type.shortName.toLowerCase() + ".json"), "{ \"variants\": { \"normal\": { \"model\": \"flansmod:" + type.shortName + "\" } } }");
                    continue;
                }
                if (type instanceof PaintableType && type.GetModel() != null) {
                    for (Paintjob paintjob : ((PaintableType)type).paintjobs) {
                        this.createJSONFile(new File(itemModelsDir, (type.shortName + (paintjob.iconName.equals("") ? "" : "_" + paintjob.iconName) + ".json").toLowerCase()), "{ \"parent\": \"builtin/generated\", \"textures\": { \"layer0\": \"flansmod:items/" + type.iconPath + (paintjob.iconName.equals("") ? "" : "_" + paintjob.iconName) + "\" }, \"display\": { \"thirdperson_righthand\": { \"rotation\": [ 0, 90, -45 ], \"translation\": [ 0, 2, -2 ], \"scale\": [ 0, 0, 0 ] }, \"thirdperson_lefthand\": { \"rotation\": [ 0, 90, -45 ], \"translation\": [ 0, 2, -2 ], \"scale\": [ 0, 0, 0 ] }, \"firstperson_righthand\": { \"rotation\": [ 0, -135, 25 ], \"translation\": [ 0, 4, 2 ], \"scale\": [ 1, 1, 1 ] }, \"firstperson_lefthand\": { \"rotation\": [ 0, -135, 25 ], \"translation\": [ 0, 4, 2 ], \"scale\": [ 1, 1, 1 ] } } }");
                    }
                    continue;
                }
                if (typeToCheckFor == EnumType.itemHolder) {
                    this.createJSONFile(new File(blockstatesDir, type.shortName.toLowerCase() + ".json"), "{ \"variants\": { \"facing=north\": { \"model\": \"flansmod:" + type.shortName + "\" }, \"facing=east\": { \"model\": \"flansmod:" + type.shortName + "\" }, \"facing=south\": { \"model\": \"flansmod:" + type.shortName + "\" }, \"facing=west\": { \"model\": \"flansmod:" + type.shortName + "\" } } }");
                    this.createJSONFile(new File(blockModelsDir, type.shortName.toLowerCase() + ".json"), "{ \"ambientocclusion\": false, \"textures\": { \"particle\": \"flansmod:items/" + type.iconPath + "\" }, \"elements\": [ {\"from\": [ 0, 0, 0 ],\"to\": [ 0, 0, 0 ], \"faces\": { \"down\":  { \"texture\": \"#down\", \"cullface\": \"down\" }, \"up\":    { \"texture\": \"#up\", \"cullface\": \"up\" }, \"north\": { \"texture\": \"#north\", \"cullface\": \"north\" }, \"south\": { \"texture\": \"#south\", \"cullface\": \"south\" }, \"west\":  { \"texture\": \"#west\", \"cullface\": \"west\" }, \"east\":  { \"texture\": \"#east\", \"cullface\": \"east\" } } } ] }");
                    this.createJSONFile(new File(itemModelsDir, type.shortName.toLowerCase() + "_item.json"), "{ \"parent\": \"builtin/generated\", \"textures\": { \"layer0\": \"flansmod:items/" + type.iconPath + "\" }, \"display\": { \"thirdperson\": { \"rotation\": [ -90, 0, 0 ], \"translation\": [ 0, 1, -3 ], \"scale\": [ 0.55, 0.55, 0.55 ] }, \"firstperson\": { \"rotation\": [ 0, -135, 25 ], \"translation\": [ 0, 4, 2 ], \"scale\": [ 1.7, 1.7, 1.7 ] } } }");
                    continue;
                }
                if (typeToCheckFor == EnumType.team || typeToCheckFor == EnumType.playerClass) continue;
                this.createJSONFile(new File(itemModelsDir, type.shortName.toLowerCase() + ".json"), "{ \"parent\": \"builtin/generated\", \"textures\": { \"layer0\": \"flansmod:items/" + type.iconPath + "\" }, \"display\": { \"thirdperson_lefthand\": { \"rotation\": [ 0, 90, -35 ], \"translation\": [ 0, 1.25, -2.5 ], \"scale\": [ 0.85, 0.85, 0.85 ] }, \"thirdperson_righthand\": { \"rotation\": [ 0, 90, -35 ], \"translation\": [ 0, 1.25, -2.5 ], \"scale\": [ 0.85, 0.85, 0.85 ] }, \"firstperson_lefthand\": { \"rotation\": [ 0, -45, 25 ], \"translation\": [ 0, 4, 2 ], \"scale\": [ 0.85, 0.85, 0.85 ] }, \"firstperson_righthand\": { \"rotation\": [ 0, -45, 25 ], \"translation\": [ 0, 4, 2 ], \"scale\": [ 0.85, 0.85, 0.85 ] } } }");
            }
            catch (Exception e) {
                FlansMod.log.throwing((Throwable)e);
            }
        }
    }

    private void createJSONFile(File file, String contents) throws Exception {
        if (FlansMod.forceUpdateJSONs) {
            if (file.exists() && !file.delete()) {
                FlansMod.log.warn("FAILED TO DELETE");
            }
            file.createNewFile();
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(contents);
            out.close();
        } else if (!file.exists()) {
            file.createNewFile();
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(contents);
            out.close();
        }
    }
}

