/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui;

import com.flansmod.client.gui.GuiDriveableMenu;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.network.PacketDriveableGUI;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiDriveableRepair
extends GuiScreen {
    private static final ResourceLocation texture = new ResourceLocation("flansmod", "gui/repair.png");
    private EntityPlayer driver;
    private EntityDriveable driving;
    private ArrayList<DriveablePart> partsToDraw = new ArrayList();
    private static RenderItem itemRenderer;
    private int guiOriginX;
    private int guiOriginY;

    public GuiDriveableRepair(EntityPlayer player) {
        this.driver = player;
        this.driving = ((EntitySeat)player.func_184187_bx()).driveable;
        for (DriveablePart part : this.driving.getDriveableData().parts.values()) {
            if (part.maxHealth <= 0) continue;
            this.partsToDraw.add(part);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        for (int i = 0; i < this.partsToDraw.size(); ++i) {
            this.field_146292_n.add(new GuiButton(i, 0, 0, 55, 20, "Repair"));
        }
        itemRenderer = this.field_146297_k.func_175599_af();
    }

    protected void func_146284_a(GuiButton button) {
        FlansMod.proxy.repairDriveable(this.driver, this.driving, this.partsToDraw.get(button.field_146127_k));
    }

    private void updateButtons() {
        int y = 43;
        for (int i = 0; i < this.partsToDraw.size(); ++i) {
            DriveablePart part = this.partsToDraw.get(i);
            GuiButton button = (GuiButton)this.field_146292_n.get(i);
            button.field_146125_m = part.health <= 0;
            button.field_146128_h = this.guiOriginX + 9;
            button.field_146129_i = this.guiOriginY + y;
            y += part.health <= 0 ? 40 : 20;
        }
    }

    public void func_73863_a(int i, int j, float f) {
        int guiWidth = 202;
        int guiHeight = 31;
        for (DriveablePart part : this.partsToDraw) {
            guiHeight += part.health <= 0 ? 40 : 20;
        }
        this.updateButtons();
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        this.func_146276_q_();
        GlStateManager.func_179147_l();
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.guiOriginX = w / 2 - guiWidth / 2;
        this.guiOriginY = h / 2 - guiHeight / 2;
        this.func_73729_b(this.guiOriginX, this.guiOriginY, 0, 0, 202, 23);
        this.func_73729_b(this.guiOriginX, this.guiOriginY + guiHeight - 8, 0, 65, 202, 8);
        this.func_73731_b(this.field_146289_q, this.driving.getDriveableType().name + " - Repair", this.guiOriginX + 7, this.guiOriginY + 7, 0xFFFFFF);
        int y = 23;
        for (DriveablePart part : this.partsToDraw) {
            boolean broken = part.health <= 0;
            this.field_146297_k.field_71446_o.func_110577_a(texture);
            this.func_73729_b(this.guiOriginX, this.guiOriginY + y, 0, 24, 202, broken ? 40 : 20);
            float percentHealth = (float)part.health / (float)part.maxHealth;
            GlStateManager.func_179124_c((float)(1.0f - percentHealth), (float)percentHealth, (float)0.0f);
            this.func_73729_b(this.guiOriginX + 121, this.guiOriginY + y + 2, 0, 73, (int)(70.0f * percentHealth), 16);
            this.func_73731_b(this.field_146289_q, part.type.getName(), this.guiOriginX + 10, this.guiOriginY + y + 6, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, (int)(percentHealth * 100.0f) + "%", this.guiOriginX + 158, this.guiOriginY + y + 6, 0xFFFFFF);
            if (broken) {
                InventoryPlayer temporaryInventory = new InventoryPlayer(null);
                temporaryInventory.func_70455_b(this.driver.field_71071_by);
                ArrayList<ItemStack> stacksNeeded = this.driving.getDriveableType().getItemsRequired(part, this.driving.getDriveableData().engine);
                for (int n = 0; n < 7; ++n) {
                    int stackNum = n + FlansMod.ticker / 60 % Math.max(1, stacksNeeded.size() - 6);
                    if (stackNum >= stacksNeeded.size()) continue;
                    ItemStack stackNeeded = stacksNeeded.get(stackNum);
                    int totalAmountFound = 0;
                    for (int m = 0; m < temporaryInventory.func_70302_i_(); ++m) {
                        ItemStack stackInSlot = temporaryInventory.func_70301_a(m).func_77946_l();
                        if (stackInSlot.func_77973_b() != stackNeeded.func_77973_b() || stackInSlot.func_77952_i() != stackNeeded.func_77952_i()) continue;
                        int amountFound = Math.min(stackInSlot.func_190916_E(), stackNeeded.func_190916_E() - totalAmountFound);
                        stackInSlot.func_190920_e(stackInSlot.func_190916_E() - amountFound);
                        if (stackInSlot.func_190916_E() <= 0) {
                            stackInSlot = ItemStack.field_190927_a.func_77946_l();
                        }
                        temporaryInventory.func_70299_a(m, stackInSlot);
                        if ((totalAmountFound += amountFound) == stackNeeded.func_190916_E()) break;
                    }
                    if (totalAmountFound < stackNeeded.func_190916_E()) {
                        this.field_146297_k.field_71446_o.func_110577_a(texture);
                        this.func_73729_b(this.guiOriginX + 67 + 18 * n, this.guiOriginY + y + 22, 202, 0, 16, 16);
                    }
                    this.drawSlotInventory(stacksNeeded.get(stackNum), this.guiOriginX + 67 + 18 * n, this.guiOriginY + y + 22);
                }
            }
            y += broken ? 40 : 20;
        }
        super.func_73863_a(i, j, f);
    }

    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int m = i - this.guiOriginX;
        int n = j - this.guiOriginY;
        if (m > 185 && m < 195 && n > 5 && n < 15) {
            if (this.driving instanceof EntityMecha) {
                FlansMod.getPacketHandler().sendToServer(new PacketDriveableGUI(4));
                this.driver.openGui((Object)FlansMod.INSTANCE, 10, this.driver.field_70170_p, this.driving.field_70176_ah, this.driving.field_70162_ai, this.driving.field_70164_aj);
            } else {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiDriveableMenu(this.driver.field_71071_by, this.driver.field_70170_p, this.driving));
            }
        }
    }

    private void drawSlotInventory(ItemStack itemstack, int i, int j) {
        if (itemstack == null || itemstack.func_190926_b()) {
            return;
        }
        itemRenderer.func_175042_a(itemstack, i, j);
        itemRenderer.func_180453_a(this.field_146289_q, itemstack, i, j, null);
    }

    public boolean func_73868_f() {
        return false;
    }
}

