/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.handlers.FlansModResourceHandler;
import com.flansmod.client.model.CustomItemRenderType;
import com.flansmod.client.model.CustomItemRenderer;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.GrenadeType;
import com.flansmod.common.guns.ItemGrenade;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderGrenade
extends Render<EntityGrenade>
implements CustomItemRenderer {
    public RenderGrenade(RenderManager renderManager) {
        super(renderManager);
        this.field_76989_e = 0.5f;
    }

    public void doRender(EntityGrenade grenade, double d, double d1, double d2, float f, float f1) {
        this.func_180548_c(grenade);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)d), (float)((float)d1), (float)((float)d2));
        if (grenade.stuck) {
            GlStateManager.func_179114_b((float)(180.0f - grenade.axes.getYaw()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)grenade.axes.getPitch(), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)grenade.axes.getRoll(), (float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            float dRoll;
            float dPitch;
            float dYaw;
            for (dYaw = grenade.axes.getYaw() - grenade.field_70126_B; dYaw > 180.0f; dYaw -= 360.0f) {
            }
            while (dYaw <= -180.0f) {
                dYaw += 360.0f;
            }
            for (dPitch = grenade.axes.getPitch() - grenade.field_70127_C; dPitch > 180.0f; dPitch -= 360.0f) {
            }
            while (dPitch <= -180.0f) {
                dPitch += 360.0f;
            }
            for (dRoll = grenade.axes.getRoll() - grenade.prevRotationRoll; dRoll > 180.0f; dRoll -= 360.0f) {
            }
            while (dRoll <= -180.0f) {
                dRoll += 360.0f;
            }
            GlStateManager.func_179114_b((float)(180.0f - grenade.field_70126_B - dYaw * f1), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(grenade.field_70127_C + dPitch * f1), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(grenade.prevRotationRoll + dRoll * f1), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        ModelBase model = grenade.type.model;
        if (model != null) {
            model.func_78088_a((Entity)grenade, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        }
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(EntityGrenade entity) {
        ResourceLocation texture = FlansModResourceHandler.getTexture(entity.type);
        if (texture == null) {
            return FlansModResourceHandler.getIcon(entity.type);
        }
        return texture;
    }

    public boolean handleRenderType(ItemStack item, CustomItemRenderType type) {
        switch (type) {
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                return item != null && item.func_77973_b() instanceof ItemGrenade && ((ItemGrenade)item.func_77973_b()).type.model != null;
            }
        }
        return false;
    }

    @Override
    public void renderItem(CustomItemRenderType type, EnumHand hand, ItemStack item, Object ... data) {
        GlStateManager.func_179094_E();
        if (item != null && item.func_77973_b() instanceof ItemGrenade) {
            GrenadeType grenadeType = ((ItemGrenade)item.func_77973_b()).type;
            if (grenadeType.model != null) {
                switch (type) {
                    case EQUIPPED: {
                        break;
                    }
                    case EQUIPPED_FIRST_PERSON: {
                        if (hand == EnumHand.MAIN_HAND) {
                            GlStateManager.func_179109_b((float)-1.25f, (float)0.8f, (float)0.1f);
                            break;
                        }
                        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)-1.0f, (float)0.8f, (float)-2.0f);
                        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                }
                Minecraft.func_71410_x().field_71446_o.func_110577_a(FlansModResourceHandler.getTexture(grenadeType));
                ModelBase model = grenadeType.model;
                model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
            }
        }
        GlStateManager.func_179121_F();
    }

    public static class Factory
    implements IRenderFactory<EntityGrenade> {
        public Render<EntityGrenade> createRenderFor(RenderManager manager) {
            return new RenderGrenade(manager);
        }
    }
}

