/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.tmt;

import com.flansmod.client.tmt.Angle3D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class Bone {
    protected Angle3D neutralAngles;
    public Angle3D relativeAngles;
    protected Angle3D absoluteAngles;
    private Vec3d positionVector;
    private float length;
    private Bone parentNode;
    protected ArrayList<Bone> childNodes;
    private ArrayList<ModelRenderer> models;
    private Map<ModelRenderer, Angle3D> modelBaseRot;
    private float offsetX;
    private float offsetY;
    private float offsetZ;

    public Bone(float x, float y, float z, float l) {
        this.neutralAngles = new Angle3D(x, y, z);
        this.relativeAngles = new Angle3D(0.0f, 0.0f, 0.0f);
        this.absoluteAngles = new Angle3D(0.0f, 0.0f, 0.0f);
        this.positionVector = new Vec3d(0.0, 0.0, 0.0);
        this.length = l;
        this.childNodes = new ArrayList();
        this.models = new ArrayList();
        this.modelBaseRot = new HashMap<ModelRenderer, Angle3D>();
        this.parentNode = null;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
        this.offsetZ = 0.0f;
        this.positionVector = new Vec3d(0.0, 0.0, 0.0);
    }

    public Bone(float xOrig, float yOrig, float zOrig, float xRot, float yRot, float zRot, float l) {
        this(xRot, yRot, zRot, l);
        this.positionVector = this.setOffset(xOrig, yOrig, zOrig);
    }

    public Bone(float x, float y, float z, float l, Bone parent) {
        this(x, y, z, l);
        this.attachBone(parent);
    }

    public void detachBone() {
        this.parentNode.childNodes.remove(this);
        this.parentNode = null;
    }

    public void attachBone(Bone parent) {
        if (this.parentNode != null) {
            this.detachBone();
        }
        this.parentNode = parent;
        parent.addChildBone(this);
        this.offsetX = parent.offsetX;
        this.offsetY = parent.offsetY;
        this.offsetZ = parent.offsetZ;
        this.resetOffset();
    }

    public Vec3d setOffset(float x, float y, float z) {
        if (this.parentNode != null) {
            Vec3d vector = this.parentNode.setOffset(x, y, z);
            this.offsetX = (float)vector.field_72450_a;
            this.offsetY = (float)vector.field_72448_b;
            this.offsetZ = (float)vector.field_72449_c;
            return vector;
        }
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        this.resetOffset(true);
        return new Vec3d((double)x, (double)y, (double)z);
    }

    public void resetOffset() {
        this.resetOffset(false);
    }

    public void resetOffset(boolean doRecursive) {
        if (this.parentNode != null) {
            this.positionVector = new Vec3d(0.0, 0.0, (double)this.parentNode.length);
            this.parentNode.setVectorRotations(this.positionVector);
            this.positionVector = this.positionVector.func_178787_e(this.parentNode.positionVector);
        }
        if (doRecursive && !this.childNodes.isEmpty()) {
            for (Bone childNode : this.childNodes) {
                childNode.resetOffset(doRecursive);
            }
        }
    }

    public void setNeutralRotation(float x, float y, float z) {
        this.neutralAngles.angleX = x;
        this.neutralAngles.angleY = y;
        this.neutralAngles.angleZ = z;
    }

    public Bone getRootParent() {
        if (this.parentNode == null) {
            return this;
        }
        return this.parentNode.getRootParent();
    }

    public void addModel(ModelRenderer model) {
        this.addModel(model, false);
    }

    public void addModel(ModelRenderer model, boolean inherit) {
        this.addModel(model, 0.0f, 0.0f, 0.0f, inherit);
    }

    public void addModel(ModelRenderer model, boolean inherit, boolean isUpright) {
        this.addModel(model, 0.0f, 0.0f, 0.0f, inherit, isUpright);
    }

    public void addModel(ModelRenderer model, float x, float y, float z) {
        this.addModel(model, x, y, z, false);
    }

    public void addModel(ModelRenderer model, float x, float y, float z, boolean inherit) {
        this.addModel(model, x, y, z, inherit, false);
    }

    public void addModel(ModelRenderer model, float x, float y, float z, boolean inherit, boolean isUpright) {
        if (inherit) {
            x += this.neutralAngles.angleX + (isUpright ? 1.5707964f : 0.0f);
            y += this.neutralAngles.angleY;
            z += this.neutralAngles.angleZ;
        }
        this.models.add(model);
        this.modelBaseRot.put(model, new Angle3D(x, y, z));
    }

    public void removeModel(ModelRenderer model) {
        this.models.remove(model);
        this.modelBaseRot.remove(model);
    }

    public Angle3D getAbsoluteAngle() {
        return new Angle3D(this.absoluteAngles.angleX, this.absoluteAngles.angleY, this.absoluteAngles.angleZ);
    }

    public Vec3d getPosition() {
        return new Vec3d(this.positionVector.field_72450_a, this.positionVector.field_72448_b, this.positionVector.field_72449_c);
    }

    protected void addChildBone(Bone bone) {
        this.childNodes.add(bone);
    }

    public void prepareDraw() {
        if (this.parentNode != null) {
            this.parentNode.prepareDraw();
        } else {
            this.setAbsoluteRotations();
            this.setVectors();
        }
    }

    public void setRotations(float x, float y, float z) {
        this.relativeAngles.angleX = x;
        this.relativeAngles.angleY = y;
        this.relativeAngles.angleZ = z;
    }

    protected void setAbsoluteRotations() {
        this.absoluteAngles.angleX = this.relativeAngles.angleX;
        this.absoluteAngles.angleY = this.relativeAngles.angleY;
        this.absoluteAngles.angleZ = this.relativeAngles.angleZ;
        for (Bone childNode : this.childNodes) {
            childNode.setAbsoluteRotations(this.absoluteAngles.angleX, this.absoluteAngles.angleY, this.absoluteAngles.angleZ);
        }
    }

    protected void setAbsoluteRotations(float x, float y, float z) {
        this.absoluteAngles.angleX = this.relativeAngles.angleX + x;
        this.absoluteAngles.angleY = this.relativeAngles.angleY + y;
        this.absoluteAngles.angleZ = this.relativeAngles.angleZ + z;
        for (Bone childNode : this.childNodes) {
            childNode.setAbsoluteRotations(this.absoluteAngles.angleX, this.absoluteAngles.angleY, this.absoluteAngles.angleZ);
        }
    }

    protected void setVectorRotations(Vec3d vector) {
        float x = this.neutralAngles.angleX + this.absoluteAngles.angleX;
        float y = this.neutralAngles.angleY + this.absoluteAngles.angleY;
        float z = this.neutralAngles.angleZ + this.absoluteAngles.angleZ;
        this.setVectorRotations(vector, x, y, z);
    }

    protected void setVectorRotations(Vec3d vector, float xRot, float yRot, float zRot) {
        float xC = MathHelper.func_76134_b((float)xRot);
        float xS = MathHelper.func_76126_a((float)xRot);
        float yC = MathHelper.func_76134_b((float)yRot);
        float yS = MathHelper.func_76126_a((float)yRot);
        float zC = MathHelper.func_76134_b((float)zRot);
        float zS = MathHelper.func_76126_a((float)zRot);
        double xVec = vector.field_72450_a;
        double yVec = vector.field_72448_b;
        double zVec = vector.field_72449_c;
        double xy = (double)xC * yVec - (double)xS * zVec;
        double xz = (double)xC * zVec + (double)xS * yVec;
        double yz = (double)yC * xz - (double)yS * xVec;
        double yx = (double)yC * xVec + (double)yS * xz;
        double zx = (double)zC * yx - (double)zS * xy;
        double zy = (double)zC * xy + (double)zS * yx;
        xVec = zx;
        yVec = zy;
        zVec = yz;
        vector = new Vec3d(xVec, yVec, zVec);
    }

    protected void add(Vec3d destVec, Vec3d srcVec) {
        destVec = destVec.func_178787_e(srcVec);
    }

    protected void setVectors() {
        Vec3d tempVec = new Vec3d(0.0, 0.0, (double)this.length);
        this.positionVector = new Vec3d((double)this.offsetX, (double)this.offsetY, (double)this.offsetZ);
        this.add(tempVec, this.positionVector);
        this.setVectorRotations(tempVec);
        for (Bone childNode : this.childNodes) {
            childNode.setVectors(tempVec);
        }
    }

    protected void setVectors(Vec3d vector) {
        this.positionVector = vector;
        Vec3d tempVec = new Vec3d(0.0, 0.0, (double)this.length);
        this.setVectorRotations(tempVec);
        this.add(tempVec, vector);
        for (Bone childNode : this.childNodes) {
            childNode.setVectors(tempVec);
        }
    }

    public void setAnglesToModels() {
        for (ModelRenderer currentModel : this.models) {
            Angle3D baseAngles = this.modelBaseRot.get(currentModel);
            currentModel.field_78795_f = baseAngles.angleX + this.absoluteAngles.angleX;
            currentModel.field_78796_g = baseAngles.angleY + this.absoluteAngles.angleY;
            currentModel.field_78808_h = baseAngles.angleZ + this.absoluteAngles.angleZ;
            currentModel.field_78800_c = (float)this.positionVector.field_72450_a;
            currentModel.field_78797_d = (float)this.positionVector.field_72448_b;
            currentModel.field_78798_e = (float)this.positionVector.field_72449_c;
        }
        for (Bone childNode : this.childNodes) {
            childNode.setAnglesToModels();
        }
    }
}

