/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.client.handlers.FlansModResourceHandler;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityShootable;
import com.flansmod.common.guns.EnumSpreadPattern;
import com.flansmod.common.guns.FireableGun;
import com.flansmod.common.guns.FiredShot;
import com.flansmod.common.guns.ShotHandler;
import com.flansmod.common.guns.raytracing.FlansModRaytracer;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBullet
extends EntityShootable
implements IEntityAdditionalSpawnData {
    private static final DataParameter<String> BULLET_TYPE = EntityDataManager.func_187226_a(EntityBullet.class, (DataSerializer)DataSerializers.field_187194_d);
    private static int bulletLife = 600;
    public int ticksInAir;
    private FiredShot shot;
    public Entity lockedOnTo;
    private float currentPenetratingPower;
    @SideOnly(value=Side.CLIENT)
    private boolean playedFlybySound;
    private UUID playeruuid;
    private UUID shooteruuid;
    private boolean checkforuuids;

    public EntityBullet(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityBullet(World world, FiredShot shot, Vec3d origin, Vec3d direction) {
        this(world);
        this.ticksInAir = 0;
        this.shot = shot;
        this.field_70180_af.func_187227_b(BULLET_TYPE, (Object)shot.getBulletType().shortName);
        this.func_70107_b(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c);
        this.field_70159_w = direction.field_72450_a;
        this.field_70181_x = direction.field_72448_b;
        this.field_70179_y = direction.field_72449_c;
        this.setArrowHeading(this.field_70159_w, this.field_70181_x, this.field_70179_y, shot.getFireableGun().getGunSpread().floatValue() * shot.getBulletType().bulletSpread, shot.getFireableGun().getBulletSpeed().floatValue());
        this.currentPenetratingPower = shot.getBulletType().penetratingPower;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(BULLET_TYPE, null);
    }

    public void setArrowHeading(double d, double d1, double d2, float spread, float speed) {
        spread /= 5.0f;
        float f2 = MathHelper.func_76133_a((double)(d * d + d1 * d1 + d2 * d2));
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d *= (double)speed;
        d1 *= (double)speed;
        d2 *= (double)speed;
        this.field_70159_w = d += this.field_70146_Z.nextGaussian() * 0.005 * (double)spread * (double)speed;
        this.field_70181_x = d1 += this.field_70146_Z.nextGaussian() * 0.005 * (double)spread * (double)speed;
        this.field_70179_y = d2 += this.field_70146_Z.nextGaussian() * 0.005 * (double)spread * (double)speed;
        float f3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
        this.getLockOnTarget();
    }

    private void getLockOnTarget() {
        BulletType type = this.shot.getBulletType();
        if (type.lockOnToPlanes || type.lockOnToVehicles || type.lockOnToMechas || type.lockOnToLivings || type.lockOnToPlayers) {
            Vector3f motionVec = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            Entity closestEntity = null;
            float closestAngle = type.maxLockOnAngle * (float)Math.PI / 180.0f;
            for (Object obj : this.field_70170_p.field_72996_f) {
                Vector3f relPosVec;
                float angle;
                Entity entity = (Entity)obj;
                if (!(type.lockOnToMechas && entity instanceof EntityMecha || type.lockOnToVehicles && entity instanceof EntityVehicle || type.lockOnToPlanes && entity instanceof EntityPlane || type.lockOnToPlayers && entity instanceof EntityPlayer) && (!type.lockOnToLivings || !(entity instanceof EntityLivingBase)) || !((angle = Math.abs(Vector3f.angle(motionVec, relPosVec = new Vector3f(entity.field_70165_t - this.field_70165_t, entity.field_70163_u - this.field_70163_u, entity.field_70161_v - this.field_70161_v)))) < closestAngle)) continue;
                closestEntity = entity;
                closestAngle = angle;
            }
            if (closestEntity != null) {
                this.lockedOnTo = closestEntity;
            }
        }
    }

    public void func_70016_h(double d, double d1, double d2) {
        this.field_70159_w = d;
        this.field_70181_x = d1;
        this.field_70179_y = d2;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(d * d + d2 * d2));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(d1, f) * 180.0 / 3.1415927410125732);
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        try {
            if (this.checkforuuids) {
                EntityPlayerMP player = null;
                EntityPlayerMP shooter = null;
                if (this.playeruuid != null) {
                    for (Entity entity : this.field_70170_p.field_72996_f) {
                        if (!entity.func_110124_au().equals(this.playeruuid) || !(entity instanceof EntityPlayerMP)) continue;
                        player = (EntityPlayerMP)entity;
                        break;
                    }
                    this.playeruuid = null;
                }
                if (this.shooteruuid != null) {
                    if (player != null && this.shooteruuid.equals(player.func_110124_au())) {
                        shooter = player;
                    } else {
                        for (Entity entity : this.field_70170_p.field_72996_f) {
                            if (!entity.func_110124_au().equals(this.shooteruuid)) continue;
                            shooter = entity;
                            break;
                        }
                    }
                    this.shooteruuid = null;
                }
                if (shooter != null) {
                    this.shot = new FiredShot(this.shot.getFireableGun(), this.shot.getBulletType(), (Entity)shooter, player);
                }
                this.checkforuuids = false;
            }
            BulletType type = this.getFiredShot().getBulletType();
            float drag = 0.99f;
            float gravity = 0.02f;
            if (this.func_70090_H()) {
                if (this.field_70170_p.field_72995_K) {
                    for (int i = 0; i < 4; ++i) {
                        float bubbleMotion = 0.25f;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)bubbleMotion, this.field_70163_u - this.field_70181_x * (double)bubbleMotion, this.field_70161_v - this.field_70179_y * (double)bubbleMotion, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                    }
                }
                drag = 0.8f;
            }
            this.field_70159_w *= (double)drag;
            this.field_70181_x *= (double)drag;
            this.field_70179_y *= (double)drag;
            this.field_70181_x -= (double)(gravity * type.fallSpeed);
            this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            float motionXZ = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.1415927410125732);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motionXZ) * 180.0 / 3.1415927410125732);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            if (this.field_70170_p.field_72995_K) {
                this.onUpdateClient();
                return;
            }
            if (FlansMod.DEBUG) {
                this.field_70170_p.func_72838_d((Entity)new EntityDebugVector(this.field_70170_p, new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y), 20));
            }
            ++this.ticksInAir;
            if (this.ticksInAir > type.fuse && type.fuse > 0 && !this.field_70128_L) {
                this.func_70106_y();
            }
            if (this.field_70173_aa > bulletLife) {
                this.func_70106_y();
            }
            if (this.field_70128_L) {
                return;
            }
            Vector3f origin = new Vector3f(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vector3f motion = new Vector3f(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (!this.field_70170_p.field_72995_K) {
                List<FlansModRaytracer.BulletHit> hits;
                Entity ignore = this.shot.getPlayerOptional().isPresent() ? (Entity)this.shot.getPlayerOptional().get() : (Entity)this.shot.getShooterOptional().orElse(null);
                Integer ping = 0;
                if (this.shot.getPlayerOptional().isPresent()) {
                    ping = this.shot.getPlayerOptional().get().field_71138_i;
                }
                if (!(hits = FlansModRaytracer.Raytrace(this.field_70170_p, ignore, this.ticksInAir > 20, this, origin, motion, ping, Float.valueOf(0.0f))).isEmpty()) {
                    for (FlansModRaytracer.BulletHit bulletHit : hits) {
                        Vector3f hitPos = new Vector3f(origin.x + motion.x * bulletHit.intersectTime, origin.y + motion.y * bulletHit.intersectTime, origin.z + motion.z * bulletHit.intersectTime);
                        this.currentPenetratingPower = ShotHandler.OnHit(this.field_70170_p, hitPos, motion, this.shot, bulletHit, Float.valueOf(this.currentPenetratingPower)).floatValue();
                        if (!(this.currentPenetratingPower <= 0.0f)) continue;
                        ShotHandler.onDetonate(this.field_70170_p, this.shot, hitPos);
                        this.func_70106_y();
                        break;
                    }
                }
            }
            if (this.lockedOnTo != null) {
                double dX = this.lockedOnTo.field_70165_t - this.field_70165_t;
                double dY = this.lockedOnTo.field_70163_u - this.field_70163_u;
                double dZ = this.lockedOnTo.field_70161_v - this.field_70161_v;
                double dXYZ = dX * dX + dY * dY + dZ * dZ;
                Vector3f relPosVec = new Vector3f(dX, dY, dZ);
                float angle = Math.abs(Vector3f.angle(motion, relPosVec));
                double lockOnPull = angle * type.lockOnForce;
                lockOnPull *= lockOnPull;
                this.field_70159_w *= (double)0.95f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.95f;
                this.field_70159_w += lockOnPull * dX / dXYZ;
                this.field_70181_x += lockOnPull * dY / dXYZ;
                this.field_70179_y += lockOnPull * dZ / dXYZ;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            super.func_70106_y();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onUpdateClient() {
        if (this.shot.getBulletType().trailParticles) {
            this.spawnParticles();
        }
        if (this.func_70068_e((Entity)Minecraft.func_71410_x().field_71439_g) < 5.0 && !this.playedFlybySound) {
            this.playedFlybySound = true;
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(FlansModResourceHandler.getSoundEvent("bulletFlyby"), SoundCategory.HOSTILE, 10.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f), (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        double dX = (this.field_70165_t - this.field_70169_q) / 10.0;
        double dY = (this.field_70163_u - this.field_70167_r) / 10.0;
        double dZ = (this.field_70161_v - this.field_70166_s) / 10.0;
        float spread = 0.1f;
        for (int i = 0; i < 10; ++i) {
            Particle particle = FlansModClient.getParticle(this.shot.getBulletType().trailParticleType, this.field_70170_p, this.field_70169_q + dX * (double)i + this.field_70146_Z.nextGaussian() * (double)spread, this.field_70167_r + dY * (double)i + this.field_70146_Z.nextGaussian() * (double)spread, this.field_70166_s + dZ * (double)i + this.field_70146_Z.nextGaussian() * (double)spread);
        }
    }

    public void func_70106_y() {
        if (this.field_70128_L) {
            return;
        }
        super.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74778_a("type", this.shot.getBulletType().shortName);
        FireableGun gun = this.shot.getFireableGun();
        if (gun != null) {
            NBTTagCompound fireablegun = new NBTTagCompound();
            fireablegun.func_74768_a("infotype", gun.getInfoType().shortName.hashCode());
            fireablegun.func_74776_a("spread", gun.getGunSpread().floatValue());
            fireablegun.func_74776_a("speed", gun.getBulletSpeed().floatValue());
            fireablegun.func_74776_a("damage", gun.getDamage().floatValue());
            fireablegun.func_74776_a("vehicledamage", gun.getDamageAgainstVehicles().floatValue());
            tag.func_74782_a("fireablegun", (NBTBase)fireablegun);
            this.shot.getPlayerOptional().ifPresent(player -> {
                NBTTagCompound compound = NBTUtil.func_186862_a((UUID)player.func_110124_au());
                tag.func_74782_a("player", (NBTBase)compound);
            });
            this.shot.getShooterOptional().ifPresent(shooter -> {
                NBTTagCompound compound = NBTUtil.func_186862_a((UUID)shooter.func_110124_au());
                tag.func_74782_a("shooter", (NBTBase)compound);
            });
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        FireableGun fireablegun = null;
        String shortName = tag.func_74779_i("type");
        BulletType type = BulletType.getBullet(shortName);
        this.field_70180_af.func_187227_b(BULLET_TYPE, (Object)shortName);
        if (tag.func_74764_b("fireablegun")) {
            NBTTagCompound gun = tag.func_74775_l("fireablegun");
            fireablegun = new FireableGun(InfoType.getType(gun.func_74762_e("infotype")), gun.func_74760_g("damage"), gun.func_74760_g("vehicledamage"), gun.func_74760_g("spread"), gun.func_74760_g("speed"), EnumSpreadPattern.circle);
        }
        if (tag.func_74764_b("player")) {
            this.playeruuid = NBTUtil.func_186860_b((NBTTagCompound)tag.func_74775_l("player"));
            this.checkforuuids = true;
        }
        if (tag.func_74764_b("shooter")) {
            this.shooteruuid = NBTUtil.func_186860_b((NBTTagCompound)tag.func_74775_l("shooter"));
            this.checkforuuids = true;
        }
        this.shot = new FiredShot(fireablegun, type);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeDouble(this.field_70159_w);
        data.writeDouble(this.field_70181_x);
        data.writeDouble(this.field_70179_y);
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.field_70159_w = data.readDouble();
            this.field_70181_x = data.readDouble();
            this.field_70179_y = data.readDouble();
        }
        catch (Exception e) {
            FlansMod.log.error("Failed to read bullet owner from server.");
            super.func_70106_y();
            FlansMod.log.throwing((Throwable)e);
        }
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public FiredShot getFiredShot() {
        if (this.shot == null) {
            this.shot = new FiredShot(null, BulletType.getBullet((String)this.field_70180_af.func_187225_a(BULLET_TYPE)));
        }
        return this.shot;
    }
}

