/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;

public class PacketGunAnimation
extends PacketBase {
    private AnimationType type;
    private AnimationType type2 = AnimationType.NONE;
    private Float minigunRotationAddSpeed;
    private Integer pumpdelay;
    private Integer pumptime;
    private Float recoil;
    private Integer reloadtime;
    private EnumHand hand;

    public PacketGunAnimation() {
    }

    public PacketGunAnimation(EnumHand hand, Integer pumpdelay, Integer pumptime, Float recoil) {
        this.type = AnimationType.SHOOT;
        this.pumpdelay = pumpdelay;
        this.pumptime = pumptime;
        this.recoil = recoil;
        this.hand = hand;
    }

    public PacketGunAnimation(EnumHand hand, Integer pumpdelay, Integer pumptime, Float recoil, Float minigunAddSpeed) {
        this(hand, pumpdelay, pumptime, recoil);
        this.type2 = AnimationType.ROTATION;
        this.minigunRotationAddSpeed = minigunAddSpeed;
    }

    public PacketGunAnimation(EnumHand hand, Float minigunAddSpeed) {
        this.type = AnimationType.ROTATION;
        this.hand = hand;
        this.minigunRotationAddSpeed = minigunAddSpeed;
    }

    public PacketGunAnimation(EnumHand hand, Integer reloadtime, Integer pumpdelay, Integer pumptime) {
        this.type = AnimationType.RELOAD;
        this.hand = hand;
        this.pumpdelay = pumpdelay;
        this.pumptime = pumptime;
        this.reloadtime = reloadtime;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(PacketGunAnimation.encode(this.type).intValue());
        data.writeInt(PacketGunAnimation.encode(this.type2).intValue());
        data.writeInt(this.hand.equals((Object)EnumHand.MAIN_HAND) ? 0 : 1);
        this.encodeInto(ctx, data, this.type);
        this.encodeInto(ctx, data, this.type2);
    }

    private void encodeInto(ChannelHandlerContext ctx, ByteBuf data, AnimationType type) {
        switch (type) {
            case NONE: {
                break;
            }
            case ROTATION: {
                data.writeFloat(this.minigunRotationAddSpeed.floatValue());
                break;
            }
            case SHOOT: {
                data.writeInt(this.pumpdelay.intValue());
                data.writeInt(this.pumptime.intValue());
                data.writeFloat(this.recoil.floatValue());
                break;
            }
            case RELOAD: {
                data.writeInt(this.pumpdelay.intValue());
                data.writeInt(this.pumptime.intValue());
                data.writeInt(this.reloadtime.intValue());
            }
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.type = PacketGunAnimation.decode(data.readInt());
        this.type2 = PacketGunAnimation.decode(data.readInt());
        this.hand = data.readInt() == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        this.decodeInto(ctx, data, this.type);
        this.decodeInto(ctx, data, this.type2);
    }

    private void decodeInto(ChannelHandlerContext ctx, ByteBuf data, AnimationType type) {
        switch (type) {
            case NONE: {
                break;
            }
            case ROTATION: {
                this.minigunRotationAddSpeed = Float.valueOf(data.readFloat());
                break;
            }
            case SHOOT: {
                this.pumpdelay = data.readInt();
                this.pumptime = data.readInt();
                this.recoil = Float.valueOf(data.readFloat());
                break;
            }
            case RELOAD: {
                this.pumpdelay = data.readInt();
                this.pumptime = data.readInt();
                this.reloadtime = data.readInt();
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        FlansMod.log.warn("Server Side should not receive this Packet");
    }

    @Override
    public void handleClientSide(EntityPlayer clientPlayer) {
        GunAnimations animations = FlansModClient.getGunAnimations((EntityLivingBase)clientPlayer, this.hand);
        this.handleAnimation(animations, this.type, clientPlayer);
        this.handleAnimation(animations, this.type2, clientPlayer);
    }

    private void handleAnimation(GunAnimations animations, AnimationType type, EntityPlayer player) {
        switch (type) {
            case NONE: {
                break;
            }
            case RELOAD: {
                animations.doReload(this.reloadtime, this.pumpdelay, this.pumptime);
                PlayerData data = PlayerHandler.getPlayerData(player);
                data.shootTimeRight = data.shootTimeLeft = (float)this.reloadtime.intValue();
                data.SetBurstRoundsRemaining(this.hand, 0);
                data.reloadingRight = true;
                data.reloadingLeft = true;
                break;
            }
            case SHOOT: {
                animations.lookAt = GunAnimations.LookAtState.NONE;
                animations.doShoot(this.pumpdelay, this.pumptime);
                FlansModClient.playerRecoil += this.recoil.floatValue();
                animations.recoil += this.recoil.floatValue();
                break;
            }
            case ROTATION: {
                animations.addMinigunBarrelRotationSpeed(this.minigunRotationAddSpeed);
            }
        }
    }

    private static AnimationType decode(Integer i) {
        if (i == 0) {
            return AnimationType.NONE;
        }
        if (i == 1) {
            return AnimationType.RELOAD;
        }
        if (i == 2) {
            return AnimationType.SHOOT;
        }
        if (i == 3) {
            return AnimationType.ROTATION;
        }
        throw new NullPointerException("Integer not kown");
    }

    private static Integer encode(AnimationType a) {
        if (a == AnimationType.NONE) {
            return 0;
        }
        if (a == AnimationType.RELOAD) {
            return 1;
        }
        if (a == AnimationType.SHOOT) {
            return 2;
        }
        if (a == AnimationType.ROTATION) {
            return 3;
        }
        throw new NullPointerException("Animation not kown");
    }

    public static enum AnimationType {
        SHOOT,
        RELOAD,
        ROTATION,
        NONE;

    }
}

