/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.client.teams.ClientTeamsData;
import com.flansmod.common.FlansMod;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.teams.RewardBox;
import com.flansmod.common.teams.TeamsManagerRanked;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketOpenRewardBox
extends PacketBase {
    public int boxHash = 0;
    public int unlockHash = 0;

    public PacketOpenRewardBox() {
    }

    public PacketOpenRewardBox(RewardBox box) {
        this.boxHash = box.hashCode();
    }

    public PacketOpenRewardBox(int box, int unlock) {
        this.boxHash = box;
        this.unlockHash = unlock;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.boxHash);
        data.writeInt(this.unlockHash);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.boxHash = data.readInt();
        this.unlockHash = data.readInt();
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        RewardBox box = RewardBox.GetRewardBox(this.boxHash);
        if (box == null) {
            FlansMod.Assert(false, "Recieved invalid reward box open packet from player " + playerEntity.getDisplayNameString());
        } else {
            FlansMod.log.info("Recieved reward box open packet from player " + playerEntity.getDisplayNameString() + " for box " + box.shortName);
            TeamsManagerRanked.OpenRewardBox(playerEntity, box);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        ClientTeamsData.UnlockReward(this.boxHash, this.unlockHash);
    }
}

