/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.teams.PlayerRankData;
import com.flansmod.common.teams.RewardBox;
import net.minecraft.entity.player.EntityPlayer;

public class RewardBoxInstance {
    public static final int INVALID_HASH = 0;
    public EnumRewardOrigin origin = EnumRewardOrigin.UNKNOWN;
    public int unlockHash = 0;
    public int boxHash = 0;
    public boolean opened = false;

    protected boolean Verify() {
        if (this.origin == EnumRewardOrigin.UNKNOWN || this.unlockHash != 0 && !this.opened || this.unlockHash == 0 && this.opened || this.boxHash == 0) {
            FlansMod.Assert(false, "Reward box failed verification!");
            return false;
        }
        return true;
    }

    public int OpenBox(PlayerRankData data) {
        if (!this.Verify()) {
            return 0;
        }
        if (this.opened) {
            FlansMod.Assert(false, "How is this even open?");
            return 0;
        }
        this.opened = true;
        this.unlockHash = RewardBox.GetRewardBox(this.boxHash).GetReward(data);
        return this.unlockHash;
    }

    private RewardBoxInstance(EnumRewardOrigin ori, int hash) {
        this.origin = ori;
        this.boxHash = hash;
    }

    private RewardBoxInstance(EnumRewardOrigin ori, RewardBox box) {
        this.origin = ori;
        this.boxHash = box.hashCode();
    }

    public static RewardBoxInstance CreateLevelUpReward(RewardBox box, EntityPlayer player) {
        FlansMod.log.info("Level up reward box created for " + player.getDisplayNameString());
        return new RewardBoxInstance(EnumRewardOrigin.LEVEL_UP, box);
    }

    public static RewardBoxInstance CreatePurchasedReward(RewardBox box, EntityPlayer player, EntityPlayer commandSender) {
        FlansMod.log.info("--------------------------------------------------------------------------------------------------------------------------------------------");
        FlansMod.log.info("PURCHASED REWARD BOX MANUALLY REDEEMED FOR USER: " + player.getDisplayNameString() + " BY PLAYER " + commandSender.getDisplayNameString());
        FlansMod.log.info("--------------------------------------------------------------------------------------------------------------------------------------------");
        return new RewardBoxInstance(EnumRewardOrigin.PURCHASE, box);
    }

    public static RewardBoxInstance CreateCheatReward(RewardBox box, String username) {
        FlansMod.log.info("---------------------------------------------------------------------------");
        FlansMod.log.info("REWARD BOX CREATED VIA OP CHEAT FOR USER: " + username);
        FlansMod.log.info("---------------------------------------------------------------------------");
        return new RewardBoxInstance(EnumRewardOrigin.OP_CHEAT, box);
    }

    public static RewardBoxInstance CreateRewardBoxInstanceFromNBT(int boxHash, int unlockHash, int type) {
        RewardBoxInstance instance = new RewardBoxInstance(EnumRewardOrigin.values()[type], boxHash);
        instance.unlockHash = unlockHash;
        instance.opened = unlockHash != 0;
        return instance;
    }

    public static RewardBoxInstance CreateClientRewardBoxInstance(int boxHash, int unlockHash) {
        RewardBoxInstance instance = new RewardBoxInstance(EnumRewardOrigin.CLIENT, boxHash);
        instance.unlockHash = unlockHash;
        instance.opened = unlockHash != 0;
        return instance;
    }

    public static enum EnumRewardOrigin {
        UNKNOWN,
        OP_CHEAT,
        LEVEL_UP,
        PURCHASE,
        CLIENT;

    }
}

