/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.network.PacketTeamSelect;
import com.flansmod.common.teams.PlayerClass;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TeamsManagerClassic
extends TeamsManager {
    private static TeamsManagerClassic INSTANCE;

    public static TeamsManagerClassic GetInstance() {
        return INSTANCE;
    }

    public TeamsManagerClassic() {
        INSTANCE = this;
    }

    @Override
    protected void OnRoundEnded() {
        super.OnRoundEnded();
    }

    @Override
    public void onPlayerLogout(EntityPlayer player) {
        super.onPlayerLogout(player);
    }

    @Override
    public void OnPlayerKilled(EntityPlayerMP victim, DamageSource source) {
        super.OnPlayerKilled(victim, source);
    }

    @Override
    public void startRound() {
        super.startRound();
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void onPlayerLogin(EntityPlayer player) {
        if (!enabled || this.currentRound == null) {
            return;
        }
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            this.sendTeamsMenuToPlayer(playerMP);
            this.currentRound.gametype.playerJoined(playerMP);
        }
    }

    @Override
    public void showTeamsMenuToAll(boolean info) {
        for (EntityPlayer entityPlayer : TeamsManagerClassic.getPlayers()) {
            PlayerData data = PlayerHandler.getPlayerData(entityPlayer);
            if (data == null || data.builder && this.playerIsOp(entityPlayer)) continue;
            this.sendTeamsMenuToPlayer((EntityPlayerMP)entityPlayer, info);
        }
    }

    @Override
    public void sendTeamsMenuToPlayer(EntityPlayerMP player, boolean info) {
        if (!enabled || this.currentRound == null || this.currentRound.teams == null) {
            return;
        }
        Team[] availableTeams = this.currentRound.gametype.getTeamsCanSpawnAs(this.currentRound, (EntityPlayer)player);
        boolean playerIsOp = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(player.func_146103_bH());
        Team[] allAvailableTeams = new Team[availableTeams.length + (playerIsOp ? 2 : 1)];
        System.arraycopy(availableTeams, 0, allAvailableTeams, 0, availableTeams.length);
        allAvailableTeams[availableTeams.length] = Team.spectators;
        TeamsManagerClassic.sendPacketToPlayer(new PacketTeamSelect(allAvailableTeams, info), player);
    }

    @Override
    public void sendClassMenuToPlayer(EntityPlayerMP player) {
        Team team = PlayerHandler.getPlayerData((EntityPlayer)player).newTeam;
        if (team == null) {
            this.sendTeamsMenuToPlayer(player);
        } else if (team != Team.spectators && team.classes.size() > 0) {
            TeamsManagerClassic.sendPacketToPlayer(new PacketTeamSelect(team.classes.toArray(new PlayerClass[team.classes.size()])), player);
        }
    }

    @Override
    protected void ReadFromNBT(NBTTagCompound tags, World world) {
        super.ReadFromNBT(tags, world);
    }

    @Override
    protected void WriteToNBT(NBTTagCompound tags) {
        super.WriteToNBT(tags);
    }

    @Override
    public void playerSelectedClass(EntityPlayerMP player, String className) {
        if (!enabled || this.currentRound == null) {
            return;
        }
        PlayerClass playerClass = PlayerClass.getClass(className);
        PlayerData data = PlayerHandler.getPlayerData((EntityPlayer)player);
        if (!data.newTeam.classes.contains(playerClass)) {
            player.func_145747_a((ITextComponent)new TextComponentString("You may not select " + playerClass.name + ". Please try again"));
            FlansMod.log.warn(player.func_70005_c_() + " tried to pick an invalid class : " + playerClass.name);
            return;
        }
        this.playerSelectedClass(player, playerClass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void SelectTeam(Team team) {
        FlansMod.getPacketHandler().sendToServer(new PacketTeamSelect(team == null ? "null" : team.shortName, false));
        Minecraft.func_71410_x().func_147108_a(null);
    }
}

