/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.types;

import com.flansmod.common.FlansMod;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.TypeFile;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class InfoType {
    public static HashMap<Integer, InfoType> infoTypes = new HashMap();
    public final String contentPack;
    public Item item;
    public int colour = 0xFFFFFF;
    public String[] recipeLine;
    public char[][] recipeGrid = new char[3][3];
    public int recipeOutput = 1;
    public boolean shapeless;
    public String smeltableFrom = null;
    public String modelString = null;
    public String name = "";
    public String shortName = "";
    public String texture = "";
    public String description = "";
    public String iconPath = "";
    public float modelScale = 1.0f;
    public boolean canDrop = true;
    public int hash = 0;
    public int dungeonChance = 1;
    public static Random random = new Random();
    public static int totalDungeonChance = 0;

    public InfoType(TypeFile file) {
        this.contentPack = file.contentPack;
    }

    public void read(TypeFile file) {
        this.preRead(file);
        while (true) {
            String[] split;
            String line = null;
            line = file.readLine();
            if (line == null) break;
            if (line.startsWith("//") || (split = line.split(" ")).length < 2) continue;
            this.read(split, file);
        }
        this.postRead(file);
        this.hash = file.hashCode();
        infoTypes.put(this.shortName.hashCode(), this);
        totalDungeonChance += this.dungeonChance;
    }

    protected void preRead(TypeFile file) {
    }

    protected void postRead(TypeFile file) {
        if (this.shortName.isEmpty()) {
            FlansMod.log.warn("ShortName not set: " + file.name);
        }
        if (this.name.isEmpty()) {
            FlansMod.log.warn("Name not set: " + file.name);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return null;
    }

    protected void read(String[] split, TypeFile file) {
        try {
            this.shortName = this.Read(split, "ShortName", this.shortName);
            this.name = this.ReadAndConcatenateMultipleStrings(split, "Name", this.name);
            this.description = this.ReadAndConcatenateMultipleStrings(split, "Description", this.description);
            this.modelString = this.Read(split, "Model", this.modelString);
            this.modelScale = this.Read(split, "ModelScale", this.modelScale);
            this.texture = this.Read(split, "Texture", this.texture);
            this.iconPath = this.Read(split, "Icon", this.iconPath);
            this.dungeonChance = this.Read(split, "DungeonProbability", this.dungeonChance);
            this.dungeonChance = this.Read(split, "DungeonLootChance", this.dungeonChance);
            this.recipeOutput = this.Read(split, "RecipeOutput", this.recipeOutput);
            this.smeltableFrom = this.Read(split, "SmeltableFrom", this.smeltableFrom);
            this.canDrop = this.Read(split, "CanDrop", this.canDrop);
            if (split[0].equals("Colour") || split[0].equals("Color")) {
                this.colour = (Integer.parseInt(split[1]) << 16) + (Integer.parseInt(split[2]) << 8) + Integer.parseInt(split[3]);
            }
            if (split[0].equals("Recipe")) {
                for (int i = 0; i < 3; ++i) {
                    String line = null;
                    line = file.readLine();
                    if (line == null) continue;
                    if (line.startsWith("//")) {
                        --i;
                        continue;
                    }
                    if (line.length() > 3) {
                        FlansMod.log.warn("Looks like a bad recipe in " + this.shortName + ". Double check whether '" + line + "' is supposed to be part of the recipe");
                    }
                    for (int j = 0; j < 3; ++j) {
                        this.recipeGrid[i][j] = j < line.length() ? (int)line.charAt(j) : 32;
                    }
                }
                this.recipeLine = split;
                this.shapeless = false;
            } else if (split[0].equals("ShapelessRecipe")) {
                this.recipeLine = split;
                this.shapeless = true;
            }
        }
        catch (Exception e) {
            FlansMod.log.error("Reading file failed : " + this.shortName);
            FlansMod.log.throwing((Throwable)e);
        }
    }

    protected boolean KeyMatches(String[] split, String key) {
        return split != null && split.length > 1 && key != null && split[0].toLowerCase().equals(key.toLowerCase());
    }

    protected int Read(String[] split, String key, int currentValue) {
        if (this.KeyMatches(split, key)) {
            if (split.length == 2) {
                try {
                    currentValue = Integer.parseInt(split[1]);
                }
                catch (Exception e) {
                    InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Passed in value is not an integer");
                }
            } else {
                InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Should be \"" + key + " <integer value>\"");
            }
        }
        return currentValue;
    }

    protected float Read(String[] split, String key, float currentValue) {
        if (this.KeyMatches(split, key)) {
            if (split.length == 2) {
                try {
                    currentValue = Float.parseFloat(split[1]);
                }
                catch (Exception e) {
                    InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Passed in value is not an float");
                }
            } else {
                InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Should be \"" + key + " <float value>\"");
            }
        }
        return currentValue;
    }

    protected double Read(String[] split, String key, double currentValue) {
        if (this.KeyMatches(split, key)) {
            if (split.length == 2) {
                try {
                    currentValue = Double.parseDouble(split[1]);
                }
                catch (Exception e) {
                    InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Passed in value is not an float");
                }
            } else {
                InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Should be \"" + key + " <float value>\"");
            }
        }
        return currentValue;
    }

    protected String Read(String[] split, String key, String currentValue) {
        if (this.KeyMatches(split, key)) {
            if (split.length == 2) {
                currentValue = split[1];
            } else {
                InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Should be \"" + key + " <singleWord>\"");
            }
        }
        return currentValue;
    }

    protected String ReadAndConcatenateMultipleStrings(String[] split, String key, String currentValue) {
        if (this.KeyMatches(split, key)) {
            if (split.length > 1) {
                currentValue = split[1];
                for (int i = 0; i < split.length - 2; ++i) {
                    currentValue = currentValue + " " + split[i + 2];
                }
            } else {
                InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Should be \"" + key + " <long string>\"");
            }
        }
        return currentValue;
    }

    protected boolean Read(String[] split, String key, boolean currentValue) {
        if (this.KeyMatches(split, key)) {
            if (split.length == 2) {
                try {
                    currentValue = Boolean.parseBoolean(split[1]);
                }
                catch (Exception e) {
                    InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Passed in value is not an boolean");
                }
            } else {
                InfoType.LogError(this.shortName, "Incorrect format for " + key + ". Should be \"" + key + " <true/false>\"");
            }
        }
        return currentValue;
    }

    protected static void LogError(String shortName, String s) {
        FlansMod.log.error("[Problem in " + shortName + ".txt]" + s);
    }

    public String toString() {
        return super.getClass().getSimpleName() + ": " + this.shortName;
    }

    public void registerItem(IForgeRegistry<Item> registry) {
        if (this.item != null) {
            registry.register((IForgeRegistryEntry)this.item);
        }
    }

    public void registerBlock(IForgeRegistry<Block> registry) {
    }

    public void addRecipe(IForgeRegistry<IRecipe> registry) {
        this.addRecipe(registry, this.getItem());
    }

    public void addRecipe(IForgeRegistry<IRecipe> registry, Item par1Item) {
        if (this.smeltableFrom != null) {
            GameRegistry.addSmelting((ItemStack)InfoType.getRecipeElement(this.smeltableFrom, 0), (ItemStack)new ItemStack(this.item), (float)0.0f);
        }
        if (this.recipeLine == null) {
            return;
        }
        try {
            if (!this.shapeless) {
                int minX = 3;
                int minY = 3;
                int maxX = -1;
                int maxY = -1;
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (this.recipeGrid[i][j] == ' ') continue;
                        if (i < minX) {
                            minX = i;
                        }
                        if (i > maxX) {
                            maxX = i;
                        }
                        if (j < minY) {
                            minY = j;
                        }
                        if (j <= maxY) continue;
                        maxY = j;
                    }
                }
                if (maxX != maxY) {
                    maxX = maxY = Math.max(maxX, maxY);
                }
                if (minX != minY) {
                    minX = minY = Math.min(minX, minY);
                }
                if (minX == 3 && maxX == -1 || minY == 3 && maxY == -1) {
                    FlansMod.log.warn("Invalid recipe grid in " + this.shortName);
                    return;
                }
                int width = maxX - minX + 1;
                int height = maxY - minY + 1;
                HashMap<Character, ItemStack> menu = new HashMap<Character, ItemStack>();
                for (int i = 0; i < (this.recipeLine.length - 1) / 2; ++i) {
                    char c = this.recipeLine[i * 2 + 1].charAt(0);
                    ItemStack stack = InfoType.getRecipeElement(this.recipeLine[i * 2 + 2]);
                    menu.put(Character.valueOf(c), stack);
                }
                NonNullList ingredients = NonNullList.func_191196_a();
                for (int i = 0; i < width; ++i) {
                    for (int j = 0; j < height; ++j) {
                        char c = this.recipeGrid[minX + i][minY + j];
                        if (c == ' ') {
                            ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemStack.field_190927_a.func_77946_l()}));
                            continue;
                        }
                        ItemStack stack = (ItemStack)menu.get(Character.valueOf(c));
                        if (stack == null || stack.func_190926_b()) {
                            FlansMod.log.warn("Failed to find " + c + " in recipe for " + this.shortName);
                            return;
                        }
                        ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack.func_77946_l()}));
                    }
                }
                registry.register(new ShapedRecipes("FlansMod", width, height, ingredients, new ItemStack(this.item, this.recipeOutput)).setRegistryName(this.shortName + "_shaped"));
            } else {
                NonNullList ingredients = NonNullList.func_191196_a();
                for (int i = 0; i < this.recipeLine.length - 1; ++i) {
                    ingredients.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{InfoType.getRecipeElement(this.recipeLine[i + 1])}));
                }
                registry.register(new ShapelessRecipes("FlansMod", new ItemStack(this.item, this.recipeOutput), ingredients).setRegistryName(this.shortName + "_shapeless"));
            }
        }
        catch (Exception e) {
            FlansMod.log.error("Failed to add recipe for : " + this.shortName);
            FlansMod.log.throwing((Throwable)e);
        }
    }

    protected int getDyeDamageValue(String dyeName) {
        int damage = -1;
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            if (!EnumDyeColor.func_176766_a((int)i).func_176762_d().equals(dyeName)) continue;
            damage = i;
        }
        if (damage == -1) {
            FlansMod.log.warn("Failed to find dye colour : " + dyeName + " while adding " + this.contentPack);
        }
        return damage;
    }

    public Item getItem() {
        return this.item;
    }

    public static ItemStack getNonRecipeElement(String str) {
        if (str.contains(".")) {
            return InfoType.getRecipeElement(str.split("\\.")[0], Integer.valueOf(str.split("\\.")[1]));
        }
        return InfoType.getRecipeElement(str, 0);
    }

    public static ItemStack getRecipeElement(String str) {
        if (str.contains(".")) {
            return InfoType.getRecipeElement(str.split("\\.")[0], Integer.valueOf(str.split("\\.")[1]));
        }
        return InfoType.getRecipeElement(str, Short.MAX_VALUE);
    }

    public static ItemStack getRecipeElement(String s, int damage) {
        return InfoType.getRecipeElement(s, 1, damage);
    }

    public static ItemStack getRecipeElement(String s, int amount, int damage) {
        return InfoType.getRecipeElement(s, amount, damage, "unknown");
    }

    public static ItemStack getRecipeElement(String s, int amount, int damage, String requester) {
        Item item;
        switch (s) {
            case "doorIron": {
                return new ItemStack(Items.field_151139_aw, amount);
            }
            case "clayItem": {
                return new ItemStack(Items.field_151119_aD, amount);
            }
            case "iron_trapdoor": {
                return new ItemStack(Blocks.field_180400_cw, amount);
            }
            case "trapdoor": {
                return new ItemStack(Blocks.field_150415_aT, amount);
            }
            case "gunpowder": {
                return new ItemStack(Items.field_151016_H, amount);
            }
            case "ingotIron": 
            case "iron": {
                return new ItemStack(Items.field_151042_j, amount);
            }
            case "boat": {
                return new ItemStack(Items.field_151124_az, amount);
            }
        }
        if (s.contains(":") ? (item = Item.func_111206_d((String)s)) != null : (item = Item.func_111206_d((String)("minecraft:" + s))) != null) {
            return new ItemStack(item, amount, damage);
        }
        for (InfoType type : infoTypes.values()) {
            if (!type.shortName.equals(s)) continue;
            return new ItemStack(type.item, amount, damage);
        }
        for (Item item2 : Item.field_150901_e) {
            if (item2 == null || !item2.func_77658_a().equals("item." + s) && !item2.func_77658_a().equals("tile." + s)) continue;
            return new ItemStack(item2, amount, damage);
        }
        FlansMod.log.warn("Could not find " + s + " when adding recipe for " + requester);
        return ItemStack.field_190927_a.func_77946_l();
    }

    public void reloadModel() {
    }

    public int hashCode() {
        return this.shortName.hashCode();
    }

    public static InfoType getType(String s) {
        return infoTypes.get(s.hashCode());
    }

    public static InfoType getType(int hash) {
        return infoTypes.get(hash);
    }

    public static InfoType getType(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_190926_b()) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFlanItem) {
            return ((IFlanItem)item).getInfoType();
        }
        return null;
    }

    public static PotionEffect getPotionEffect(String[] split) {
        int potionID = Integer.parseInt(split[1]);
        int duration = Integer.parseInt(split[2]);
        int amplifier = Integer.parseInt(split[3]);
        return new PotionEffect(Potion.func_188412_a((int)potionID), duration, amplifier, false, false);
    }

    public static Material getMaterial(String mat) {
        return Material.field_151578_c;
    }

    public void addLoot(LootTableLoadEvent event) {
        if (this.dungeonChance > 0) {
            LootPool pool = event.getTable().getPool("FlansMod");
            if (pool == null) {
                pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(1.0f, 1.0f), "FlansMod");
                event.getTable().addPool(pool);
            }
            LootEntryItem entry = new LootEntryItem(this.item, FlansMod.dungeonLootChance * this.dungeonChance, 1, new LootFunction[0], new LootCondition[0], this.shortName);
            if (pool != null) {
                pool.addEntry((LootEntry)entry);
            }
        }
    }

    public static interface ParseFunc<T extends InfoType> {
        public void Parse(String[] var1, T var2);
    }
}

